Scriptname GuardBeGoneScript extends ObjectReference

bool Property BlameCaster = false auto
;Actor Property PlayerRef auto
float Property RangeFT auto
bool On
Event OnEquipped(Actor akActor)
	On = true
	KillGuards(akActor)
endEvent

Event OnUnequipped(Actor akActor)
	On = false
	KillGuards(akActor)
endEvent

Function KillGuards(Actor akActor)
	while(On == true)
		Actor target = Game.FindRandomActorFromRef(AkActor,RangeFT*100)
		;Debug.Notification(RangeFT*10)
		if(target != Game.GetPlayer())
			if(target.IsGuard())
			;Debug.Notification("Found Guard")
				if(BlameCaster == true)
					target.kill(akActor)
				else
					target.kill(target)
				endif
			endif
		else
		;Debug.Notification("Found Player")
		endif
	endwhile
endFunction